package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  ResourceEvaluationId,
  BaseResourceId,
  StringWithCharLimit256
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetComplianceDetailsByResourceRequest(
    resourceType: Optional[StringWithCharLimit256] = Optional.Absent,
    resourceId: Optional[BaseResourceId] = Optional.Absent,
    complianceTypes: Optional[Iterable[zio.aws.config.model.ComplianceType]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    resourceEvaluationId: Optional[ResourceEvaluationId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest = {
    import GetComplianceDetailsByResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest
      .builder()
      .optionallyWith(
        resourceType.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        resourceId.map(value => BaseResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        complianceTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.complianceTypesWithStrings)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        resourceEvaluationId.map(value =>
          ResourceEvaluationId.unwrap(value): java.lang.String
        )
      )(_.resourceEvaluationId)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetComplianceDetailsByResourceRequest.ReadOnly =
    zio.aws.config.model.GetComplianceDetailsByResourceRequest
      .wrap(buildAwsValue())
}
object GetComplianceDetailsByResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.GetComplianceDetailsByResourceRequest =
      zio.aws.config.model.GetComplianceDetailsByResourceRequest(
        resourceType.map(value => value),
        resourceId.map(value => value),
        complianceTypes.map(value => value),
        nextToken.map(value => value),
        resourceEvaluationId.map(value => value)
      )
    def resourceType: Optional[StringWithCharLimit256]
    def resourceId: Optional[BaseResourceId]
    def complianceTypes: Optional[List[zio.aws.config.model.ComplianceType]]
    def nextToken: Optional[String]
    def resourceEvaluationId: Optional[ResourceEvaluationId]
    def getResourceType: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, BaseResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getComplianceTypes
        : ZIO[Any, AwsError, List[zio.aws.config.model.ComplianceType]] =
      AwsError.unwrapOptionField("complianceTypes", complianceTypes)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResourceEvaluationId: ZIO[Any, AwsError, ResourceEvaluationId] =
      AwsError.unwrapOptionField("resourceEvaluationId", resourceEvaluationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest
  ) extends zio.aws.config.model.GetComplianceDetailsByResourceRequest.ReadOnly {
    override val resourceType: Optional[StringWithCharLimit256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit256(value)
        )
    override val resourceId: Optional[BaseResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.config.model.primitives.BaseResourceId(value))
    override val complianceTypes
        : Optional[List[zio.aws.config.model.ComplianceType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.ComplianceType.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val resourceEvaluationId: Optional[ResourceEvaluationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceEvaluationId())
        .map(value =>
          zio.aws.config.model.primitives.ResourceEvaluationId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest
  ): zio.aws.config.model.GetComplianceDetailsByResourceRequest.ReadOnly =
    new Wrapper(impl)
}
