package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetComplianceSummaryByConfigRuleResponse(
    complianceSummary: Optional[zio.aws.config.model.ComplianceSummary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleResponse = {
    import GetComplianceSummaryByConfigRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleResponse
      .builder()
      .optionallyWith(complianceSummary.map(value => value.buildAwsValue()))(
        _.complianceSummary
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetComplianceSummaryByConfigRuleResponse.ReadOnly =
    zio.aws.config.model.GetComplianceSummaryByConfigRuleResponse
      .wrap(buildAwsValue())
}
object GetComplianceSummaryByConfigRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.GetComplianceSummaryByConfigRuleResponse =
      zio.aws.config.model.GetComplianceSummaryByConfigRuleResponse(
        complianceSummary.map(value => value.asEditable)
      )
    def complianceSummary
        : Optional[zio.aws.config.model.ComplianceSummary.ReadOnly]
    def getComplianceSummary
        : ZIO[Any, AwsError, zio.aws.config.model.ComplianceSummary.ReadOnly] =
      AwsError.unwrapOptionField("complianceSummary", complianceSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleResponse
  ) extends zio.aws.config.model.GetComplianceSummaryByConfigRuleResponse.ReadOnly {
    override val complianceSummary
        : Optional[zio.aws.config.model.ComplianceSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceSummary())
        .map(value => zio.aws.config.model.ComplianceSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleResponse
  ): zio.aws.config.model.GetComplianceSummaryByConfigRuleResponse.ReadOnly =
    new Wrapper(impl)
}
