package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetComplianceSummaryByResourceTypeResponse(
    complianceSummariesByResourceType: Optional[
      Iterable[zio.aws.config.model.ComplianceSummaryByResourceType]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeResponse = {
    import GetComplianceSummaryByResourceTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeResponse
      .builder()
      .optionallyWith(
        complianceSummariesByResourceType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.complianceSummariesByResourceType)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetComplianceSummaryByResourceTypeResponse.ReadOnly =
    zio.aws.config.model.GetComplianceSummaryByResourceTypeResponse
      .wrap(buildAwsValue())
}
object GetComplianceSummaryByResourceTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.GetComplianceSummaryByResourceTypeResponse =
      zio.aws.config.model.GetComplianceSummaryByResourceTypeResponse(
        complianceSummariesByResourceType.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def complianceSummariesByResourceType: Optional[
      List[zio.aws.config.model.ComplianceSummaryByResourceType.ReadOnly]
    ]
    def getComplianceSummariesByResourceType: ZIO[Any, AwsError, List[
      zio.aws.config.model.ComplianceSummaryByResourceType.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "complianceSummariesByResourceType",
      complianceSummariesByResourceType
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeResponse
  ) extends zio.aws.config.model.GetComplianceSummaryByResourceTypeResponse.ReadOnly {
    override val complianceSummariesByResourceType: Optional[
      List[zio.aws.config.model.ComplianceSummaryByResourceType.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.complianceSummariesByResourceType())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.ComplianceSummaryByResourceType.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeResponse
  ): zio.aws.config.model.GetComplianceSummaryByResourceTypeResponse.ReadOnly =
    new Wrapper(impl)
}
