package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.ResourceEvaluationId
import scala.jdk.CollectionConverters.*
final case class GetResourceEvaluationSummaryRequest(
    resourceEvaluationId: ResourceEvaluationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetResourceEvaluationSummaryRequest = {
    import GetResourceEvaluationSummaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetResourceEvaluationSummaryRequest
      .builder()
      .resourceEvaluationId(
        ResourceEvaluationId.unwrap(resourceEvaluationId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetResourceEvaluationSummaryRequest.ReadOnly =
    zio.aws.config.model.GetResourceEvaluationSummaryRequest
      .wrap(buildAwsValue())
}
object GetResourceEvaluationSummaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetResourceEvaluationSummaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.GetResourceEvaluationSummaryRequest =
      zio.aws.config.model
        .GetResourceEvaluationSummaryRequest(resourceEvaluationId)
    def resourceEvaluationId: ResourceEvaluationId
    def getResourceEvaluationId: ZIO[Any, Nothing, ResourceEvaluationId] =
      ZIO.succeed(resourceEvaluationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetResourceEvaluationSummaryRequest
  ) extends zio.aws.config.model.GetResourceEvaluationSummaryRequest.ReadOnly {
    override val resourceEvaluationId: ResourceEvaluationId =
      zio.aws.config.model.primitives
        .ResourceEvaluationId(impl.resourceEvaluationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetResourceEvaluationSummaryRequest
  ): zio.aws.config.model.GetResourceEvaluationSummaryRequest.ReadOnly =
    new Wrapper(impl)
}
