package zio.aws.config.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{Date, ResourceEvaluationId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetResourceEvaluationSummaryResponse(
    resourceEvaluationId: Optional[ResourceEvaluationId] = Optional.Absent,
    evaluationMode: Optional[zio.aws.config.model.EvaluationMode] =
      Optional.Absent,
    evaluationStatus: Optional[zio.aws.config.model.EvaluationStatus] =
      Optional.Absent,
    evaluationStartTimestamp: Optional[Date] = Optional.Absent,
    compliance: Optional[zio.aws.config.model.ComplianceType] = Optional.Absent,
    evaluationContext: Optional[zio.aws.config.model.EvaluationContext] =
      Optional.Absent,
    resourceDetails: Optional[zio.aws.config.model.ResourceDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetResourceEvaluationSummaryResponse = {
    import GetResourceEvaluationSummaryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetResourceEvaluationSummaryResponse
      .builder()
      .optionallyWith(
        resourceEvaluationId.map(value =>
          ResourceEvaluationId.unwrap(value): java.lang.String
        )
      )(_.resourceEvaluationId)
      .optionallyWith(evaluationMode.map(value => value.unwrap))(
        _.evaluationMode
      )
      .optionallyWith(evaluationStatus.map(value => value.buildAwsValue()))(
        _.evaluationStatus
      )
      .optionallyWith(
        evaluationStartTimestamp.map(value => Date.unwrap(value): Instant)
      )(_.evaluationStartTimestamp)
      .optionallyWith(compliance.map(value => value.unwrap))(_.compliance)
      .optionallyWith(evaluationContext.map(value => value.buildAwsValue()))(
        _.evaluationContext
      )
      .optionallyWith(resourceDetails.map(value => value.buildAwsValue()))(
        _.resourceDetails
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetResourceEvaluationSummaryResponse.ReadOnly =
    zio.aws.config.model.GetResourceEvaluationSummaryResponse
      .wrap(buildAwsValue())
}
object GetResourceEvaluationSummaryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetResourceEvaluationSummaryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.GetResourceEvaluationSummaryResponse =
      zio.aws.config.model.GetResourceEvaluationSummaryResponse(
        resourceEvaluationId.map(value => value),
        evaluationMode.map(value => value),
        evaluationStatus.map(value => value.asEditable),
        evaluationStartTimestamp.map(value => value),
        compliance.map(value => value),
        evaluationContext.map(value => value.asEditable),
        resourceDetails.map(value => value.asEditable)
      )
    def resourceEvaluationId: Optional[ResourceEvaluationId]
    def evaluationMode: Optional[zio.aws.config.model.EvaluationMode]
    def evaluationStatus
        : Optional[zio.aws.config.model.EvaluationStatus.ReadOnly]
    def evaluationStartTimestamp: Optional[Date]
    def compliance: Optional[zio.aws.config.model.ComplianceType]
    def evaluationContext
        : Optional[zio.aws.config.model.EvaluationContext.ReadOnly]
    def resourceDetails: Optional[zio.aws.config.model.ResourceDetails.ReadOnly]
    def getResourceEvaluationId: ZIO[Any, AwsError, ResourceEvaluationId] =
      AwsError.unwrapOptionField("resourceEvaluationId", resourceEvaluationId)
    def getEvaluationMode
        : ZIO[Any, AwsError, zio.aws.config.model.EvaluationMode] =
      AwsError.unwrapOptionField("evaluationMode", evaluationMode)
    def getEvaluationStatus
        : ZIO[Any, AwsError, zio.aws.config.model.EvaluationStatus.ReadOnly] =
      AwsError.unwrapOptionField("evaluationStatus", evaluationStatus)
    def getEvaluationStartTimestamp: ZIO[Any, AwsError, Date] = AwsError
      .unwrapOptionField("evaluationStartTimestamp", evaluationStartTimestamp)
    def getCompliance: ZIO[Any, AwsError, zio.aws.config.model.ComplianceType] =
      AwsError.unwrapOptionField("compliance", compliance)
    def getEvaluationContext
        : ZIO[Any, AwsError, zio.aws.config.model.EvaluationContext.ReadOnly] =
      AwsError.unwrapOptionField("evaluationContext", evaluationContext)
    def getResourceDetails
        : ZIO[Any, AwsError, zio.aws.config.model.ResourceDetails.ReadOnly] =
      AwsError.unwrapOptionField("resourceDetails", resourceDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetResourceEvaluationSummaryResponse
  ) extends zio.aws.config.model.GetResourceEvaluationSummaryResponse.ReadOnly {
    override val resourceEvaluationId: Optional[ResourceEvaluationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceEvaluationId())
        .map(value =>
          zio.aws.config.model.primitives.ResourceEvaluationId(value)
        )
    override val evaluationMode: Optional[zio.aws.config.model.EvaluationMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationMode())
        .map(value => zio.aws.config.model.EvaluationMode.wrap(value))
    override val evaluationStatus
        : Optional[zio.aws.config.model.EvaluationStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationStatus())
        .map(value => zio.aws.config.model.EvaluationStatus.wrap(value))
    override val evaluationStartTimestamp: Optional[Date] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationStartTimestamp())
        .map(value => zio.aws.config.model.primitives.Date(value))
    override val compliance: Optional[zio.aws.config.model.ComplianceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compliance())
        .map(value => zio.aws.config.model.ComplianceType.wrap(value))
    override val evaluationContext
        : Optional[zio.aws.config.model.EvaluationContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationContext())
        .map(value => zio.aws.config.model.EvaluationContext.wrap(value))
    override val resourceDetails
        : Optional[zio.aws.config.model.ResourceDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceDetails())
        .map(value => zio.aws.config.model.ResourceDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetResourceEvaluationSummaryResponse
  ): zio.aws.config.model.GetResourceEvaluationSummaryResponse.ReadOnly =
    new Wrapper(impl)
}
