package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.QueryName
import scala.jdk.CollectionConverters.*
final case class GetStoredQueryRequest(queryName: QueryName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetStoredQueryRequest = {
    import GetStoredQueryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetStoredQueryRequest
      .builder()
      .queryName(QueryName.unwrap(queryName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.config.model.GetStoredQueryRequest.ReadOnly =
    zio.aws.config.model.GetStoredQueryRequest.wrap(buildAwsValue())
}
object GetStoredQueryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetStoredQueryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.GetStoredQueryRequest =
      zio.aws.config.model.GetStoredQueryRequest(queryName)
    def queryName: QueryName
    def getQueryName: ZIO[Any, Nothing, QueryName] = ZIO.succeed(queryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetStoredQueryRequest
  ) extends zio.aws.config.model.GetStoredQueryRequest.ReadOnly {
    override val queryName: QueryName =
      zio.aws.config.model.primitives.QueryName(impl.queryName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetStoredQueryRequest
  ): zio.aws.config.model.GetStoredQueryRequest.ReadOnly = new Wrapper(impl)
}
