package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.StringWithCharLimit256
import scala.jdk.CollectionConverters.*
final case class GroupedResourceCount(
    groupName: StringWithCharLimit256,
    resourceCount: Long
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GroupedResourceCount = {
    import GroupedResourceCount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GroupedResourceCount
      .builder()
      .groupName(StringWithCharLimit256.unwrap(groupName): java.lang.String)
      .resourceCount(resourceCount: java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.config.model.GroupedResourceCount.ReadOnly =
    zio.aws.config.model.GroupedResourceCount.wrap(buildAwsValue())
}
object GroupedResourceCount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GroupedResourceCount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.GroupedResourceCount =
      zio.aws.config.model.GroupedResourceCount(groupName, resourceCount)
    def groupName: StringWithCharLimit256
    def resourceCount: Long
    def getGroupName: ZIO[Any, Nothing, StringWithCharLimit256] =
      ZIO.succeed(groupName)
    def getResourceCount: ZIO[Any, Nothing, Long] = ZIO.succeed(resourceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GroupedResourceCount
  ) extends zio.aws.config.model.GroupedResourceCount.ReadOnly {
    override val groupName: StringWithCharLimit256 =
      zio.aws.config.model.primitives.StringWithCharLimit256(impl.groupName())
    override val resourceCount: Long = impl.resourceCount(): Long
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GroupedResourceCount
  ): zio.aws.config.model.GroupedResourceCount.ReadOnly = new Wrapper(impl)
}
