package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListStoredQueriesResponse(
    storedQueryMetadata: Optional[
      Iterable[zio.aws.config.model.StoredQueryMetadata]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ListStoredQueriesResponse = {
    import ListStoredQueriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ListStoredQueriesResponse
      .builder()
      .optionallyWith(
        storedQueryMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storedQueryMetadata)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.ListStoredQueriesResponse.ReadOnly =
    zio.aws.config.model.ListStoredQueriesResponse.wrap(buildAwsValue())
}
object ListStoredQueriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ListStoredQueriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ListStoredQueriesResponse =
      zio.aws.config.model.ListStoredQueriesResponse(
        storedQueryMetadata.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def storedQueryMetadata
        : Optional[List[zio.aws.config.model.StoredQueryMetadata.ReadOnly]]
    def nextToken: Optional[String]
    def getStoredQueryMetadata: ZIO[Any, AwsError, List[
      zio.aws.config.model.StoredQueryMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("storedQueryMetadata", storedQueryMetadata)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ListStoredQueriesResponse
  ) extends zio.aws.config.model.ListStoredQueriesResponse.ReadOnly {
    override val storedQueryMetadata
        : Optional[List[zio.aws.config.model.StoredQueryMetadata.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storedQueryMetadata())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.StoredQueryMetadata.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ListStoredQueriesResponse
  ): zio.aws.config.model.ListStoredQueriesResponse.ReadOnly = new Wrapper(impl)
}
