package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait MessageType {
  def unwrap: software.amazon.awssdk.services.config.model.MessageType
}
object MessageType {
  def wrap(
      value: software.amazon.awssdk.services.config.model.MessageType
  ): zio.aws.config.model.MessageType = value match {
    case software.amazon.awssdk.services.config.model.MessageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.MessageType.CONFIGURATION_ITEM_CHANGE_NOTIFICATION =>
      val r = ConfigurationItemChangeNotification
      r
    case software.amazon.awssdk.services.config.model.MessageType.CONFIGURATION_SNAPSHOT_DELIVERY_COMPLETED =>
      val r = ConfigurationSnapshotDeliveryCompleted
      r
    case software.amazon.awssdk.services.config.model.MessageType.SCHEDULED_NOTIFICATION =>
      val r = ScheduledNotification
      r
    case software.amazon.awssdk.services.config.model.MessageType.OVERSIZED_CONFIGURATION_ITEM_CHANGE_NOTIFICATION =>
      val r = OversizedConfigurationItemChangeNotification
      r
  }
  case object unknownToSdkVersion extends zio.aws.config.model.MessageType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.MessageType =
      software.amazon.awssdk.services.config.model.MessageType.UNKNOWN_TO_SDK_VERSION
  }
  case object ConfigurationItemChangeNotification
      extends zio.aws.config.model.MessageType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.MessageType =
      software.amazon.awssdk.services.config.model.MessageType.CONFIGURATION_ITEM_CHANGE_NOTIFICATION
  }
  case object ConfigurationSnapshotDeliveryCompleted
      extends zio.aws.config.model.MessageType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.MessageType =
      software.amazon.awssdk.services.config.model.MessageType.CONFIGURATION_SNAPSHOT_DELIVERY_COMPLETED
  }
  case object ScheduledNotification extends zio.aws.config.model.MessageType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.MessageType =
      software.amazon.awssdk.services.config.model.MessageType.SCHEDULED_NOTIFICATION
  }
  case object OversizedConfigurationItemChangeNotification
      extends zio.aws.config.model.MessageType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.MessageType =
      software.amazon.awssdk.services.config.model.MessageType.OVERSIZED_CONFIGURATION_ITEM_CHANGE_NOTIFICATION
  }
}
