package zio.aws.config.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{
  Date,
  AccountId,
  StringWithCharLimit256,
  OrganizationConfigRuleName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class OrganizationConfigRule(
    organizationConfigRuleName: OrganizationConfigRuleName,
    organizationConfigRuleArn: StringWithCharLimit256,
    organizationManagedRuleMetadata: Optional[
      zio.aws.config.model.OrganizationManagedRuleMetadata
    ] = Optional.Absent,
    organizationCustomRuleMetadata: Optional[
      zio.aws.config.model.OrganizationCustomRuleMetadata
    ] = Optional.Absent,
    excludedAccounts: Optional[Iterable[AccountId]] = Optional.Absent,
    lastUpdateTime: Optional[Date] = Optional.Absent,
    organizationCustomPolicyRuleMetadata: Optional[
      zio.aws.config.model.OrganizationCustomPolicyRuleMetadataNoPolicy
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.OrganizationConfigRule = {
    import OrganizationConfigRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.OrganizationConfigRule
      .builder()
      .organizationConfigRuleName(
        OrganizationConfigRuleName.unwrap(
          organizationConfigRuleName
        ): java.lang.String
      )
      .organizationConfigRuleArn(
        StringWithCharLimit256.unwrap(
          organizationConfigRuleArn
        ): java.lang.String
      )
      .optionallyWith(
        organizationManagedRuleMetadata.map(value => value.buildAwsValue())
      )(_.organizationManagedRuleMetadata)
      .optionallyWith(
        organizationCustomRuleMetadata.map(value => value.buildAwsValue())
      )(_.organizationCustomRuleMetadata)
      .optionallyWith(
        excludedAccounts.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.excludedAccounts)
      .optionallyWith(lastUpdateTime.map(value => Date.unwrap(value): Instant))(
        _.lastUpdateTime
      )
      .optionallyWith(
        organizationCustomPolicyRuleMetadata.map(value => value.buildAwsValue())
      )(_.organizationCustomPolicyRuleMetadata)
      .build()
  }
  def asReadOnly: zio.aws.config.model.OrganizationConfigRule.ReadOnly =
    zio.aws.config.model.OrganizationConfigRule.wrap(buildAwsValue())
}
object OrganizationConfigRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.OrganizationConfigRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.OrganizationConfigRule =
      zio.aws.config.model.OrganizationConfigRule(
        organizationConfigRuleName,
        organizationConfigRuleArn,
        organizationManagedRuleMetadata.map(value => value.asEditable),
        organizationCustomRuleMetadata.map(value => value.asEditable),
        excludedAccounts.map(value => value),
        lastUpdateTime.map(value => value),
        organizationCustomPolicyRuleMetadata.map(value => value.asEditable)
      )
    def organizationConfigRuleName: OrganizationConfigRuleName
    def organizationConfigRuleArn: StringWithCharLimit256
    def organizationManagedRuleMetadata: Optional[
      zio.aws.config.model.OrganizationManagedRuleMetadata.ReadOnly
    ]
    def organizationCustomRuleMetadata
        : Optional[zio.aws.config.model.OrganizationCustomRuleMetadata.ReadOnly]
    def excludedAccounts: Optional[List[AccountId]]
    def lastUpdateTime: Optional[Date]
    def organizationCustomPolicyRuleMetadata: Optional[
      zio.aws.config.model.OrganizationCustomPolicyRuleMetadataNoPolicy.ReadOnly
    ]
    def getOrganizationConfigRuleName
        : ZIO[Any, Nothing, OrganizationConfigRuleName] =
      ZIO.succeed(organizationConfigRuleName)
    def getOrganizationConfigRuleArn
        : ZIO[Any, Nothing, StringWithCharLimit256] =
      ZIO.succeed(organizationConfigRuleArn)
    def getOrganizationManagedRuleMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.OrganizationManagedRuleMetadata.ReadOnly
    ] = AwsError.unwrapOptionField(
      "organizationManagedRuleMetadata",
      organizationManagedRuleMetadata
    )
    def getOrganizationCustomRuleMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.OrganizationCustomRuleMetadata.ReadOnly
    ] = AwsError.unwrapOptionField(
      "organizationCustomRuleMetadata",
      organizationCustomRuleMetadata
    )
    def getExcludedAccounts: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("excludedAccounts", excludedAccounts)
    def getLastUpdateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
    def getOrganizationCustomPolicyRuleMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.OrganizationCustomPolicyRuleMetadataNoPolicy.ReadOnly
    ] = AwsError.unwrapOptionField(
      "organizationCustomPolicyRuleMetadata",
      organizationCustomPolicyRuleMetadata
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.OrganizationConfigRule
  ) extends zio.aws.config.model.OrganizationConfigRule.ReadOnly {
    override val organizationConfigRuleName: OrganizationConfigRuleName =
      zio.aws.config.model.primitives
        .OrganizationConfigRuleName(impl.organizationConfigRuleName())
    override val organizationConfigRuleArn: StringWithCharLimit256 =
      zio.aws.config.model.primitives
        .StringWithCharLimit256(impl.organizationConfigRuleArn())
    override val organizationManagedRuleMetadata: Optional[
      zio.aws.config.model.OrganizationManagedRuleMetadata.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.organizationManagedRuleMetadata())
      .map(value =>
        zio.aws.config.model.OrganizationManagedRuleMetadata.wrap(value)
      )
    override val organizationCustomRuleMetadata: Optional[
      zio.aws.config.model.OrganizationCustomRuleMetadata.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.organizationCustomRuleMetadata())
      .map(value =>
        zio.aws.config.model.OrganizationCustomRuleMetadata.wrap(value)
      )
    override val excludedAccounts: Optional[List[AccountId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludedAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.primitives.AccountId(item)
          }.toList
        )
    override val lastUpdateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdateTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val organizationCustomPolicyRuleMetadata: Optional[
      zio.aws.config.model.OrganizationCustomPolicyRuleMetadataNoPolicy.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.organizationCustomPolicyRuleMetadata())
      .map(value =>
        zio.aws.config.model.OrganizationCustomPolicyRuleMetadataNoPolicy
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.OrganizationConfigRule
  ): zio.aws.config.model.OrganizationConfigRule.ReadOnly = new Wrapper(impl)
}
