package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutAggregationAuthorizationResponse(
    aggregationAuthorization: Optional[
      zio.aws.config.model.AggregationAuthorization
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutAggregationAuthorizationResponse = {
    import PutAggregationAuthorizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutAggregationAuthorizationResponse
      .builder()
      .optionallyWith(
        aggregationAuthorization.map(value => value.buildAwsValue())
      )(_.aggregationAuthorization)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.PutAggregationAuthorizationResponse.ReadOnly =
    zio.aws.config.model.PutAggregationAuthorizationResponse
      .wrap(buildAwsValue())
}
object PutAggregationAuthorizationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutAggregationAuthorizationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutAggregationAuthorizationResponse =
      zio.aws.config.model.PutAggregationAuthorizationResponse(
        aggregationAuthorization.map(value => value.asEditable)
      )
    def aggregationAuthorization
        : Optional[zio.aws.config.model.AggregationAuthorization.ReadOnly]
    def getAggregationAuthorization: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.AggregationAuthorization.ReadOnly
    ] = AwsError.unwrapOptionField(
      "aggregationAuthorization",
      aggregationAuthorization
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutAggregationAuthorizationResponse
  ) extends zio.aws.config.model.PutAggregationAuthorizationResponse.ReadOnly {
    override val aggregationAuthorization
        : Optional[zio.aws.config.model.AggregationAuthorization.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregationAuthorization())
        .map(value => zio.aws.config.model.AggregationAuthorization.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutAggregationAuthorizationResponse
  ): zio.aws.config.model.PutAggregationAuthorizationResponse.ReadOnly =
    new Wrapper(impl)
}
