package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutConfigRuleRequest(
    configRule: zio.aws.config.model.ConfigRule,
    tags: Optional[Iterable[zio.aws.config.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutConfigRuleRequest = {
    import PutConfigRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutConfigRuleRequest
      .builder()
      .configRule(configRule.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.config.model.PutConfigRuleRequest.ReadOnly =
    zio.aws.config.model.PutConfigRuleRequest.wrap(buildAwsValue())
}
object PutConfigRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutConfigRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutConfigRuleRequest =
      zio.aws.config.model.PutConfigRuleRequest(
        configRule.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def configRule: zio.aws.config.model.ConfigRule.ReadOnly
    def tags: Optional[List[zio.aws.config.model.Tag.ReadOnly]]
    def getConfigRule
        : ZIO[Any, Nothing, zio.aws.config.model.ConfigRule.ReadOnly] =
      ZIO.succeed(configRule)
    def getTags: ZIO[Any, AwsError, List[zio.aws.config.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutConfigRuleRequest
  ) extends zio.aws.config.model.PutConfigRuleRequest.ReadOnly {
    override val configRule: zio.aws.config.model.ConfigRule.ReadOnly =
      zio.aws.config.model.ConfigRule.wrap(impl.configRule())
    override val tags: Optional[List[zio.aws.config.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutConfigRuleRequest
  ): zio.aws.config.model.PutConfigRuleRequest.ReadOnly = new Wrapper(impl)
}
