package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutConfigurationRecorderRequest(
    configurationRecorder: zio.aws.config.model.ConfigurationRecorder
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutConfigurationRecorderRequest = {
    import PutConfigurationRecorderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutConfigurationRecorderRequest
      .builder()
      .configurationRecorder(configurationRecorder.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.PutConfigurationRecorderRequest.ReadOnly =
    zio.aws.config.model.PutConfigurationRecorderRequest.wrap(buildAwsValue())
}
object PutConfigurationRecorderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutConfigurationRecorderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutConfigurationRecorderRequest =
      zio.aws.config.model
        .PutConfigurationRecorderRequest(configurationRecorder.asEditable)
    def configurationRecorder
        : zio.aws.config.model.ConfigurationRecorder.ReadOnly
    def getConfigurationRecorder: ZIO[
      Any,
      Nothing,
      zio.aws.config.model.ConfigurationRecorder.ReadOnly
    ] = ZIO.succeed(configurationRecorder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutConfigurationRecorderRequest
  ) extends zio.aws.config.model.PutConfigurationRecorderRequest.ReadOnly {
    override val configurationRecorder
        : zio.aws.config.model.ConfigurationRecorder.ReadOnly =
      zio.aws.config.model.ConfigurationRecorder
        .wrap(impl.configurationRecorder())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutConfigurationRecorderRequest
  ): zio.aws.config.model.PutConfigurationRecorderRequest.ReadOnly =
    new Wrapper(impl)
}
