package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.ConfigRuleName
import scala.jdk.CollectionConverters.*
final case class PutExternalEvaluationRequest(
    configRuleName: ConfigRuleName,
    externalEvaluation: zio.aws.config.model.ExternalEvaluation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutExternalEvaluationRequest = {
    import PutExternalEvaluationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutExternalEvaluationRequest
      .builder()
      .configRuleName(ConfigRuleName.unwrap(configRuleName): java.lang.String)
      .externalEvaluation(externalEvaluation.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.config.model.PutExternalEvaluationRequest.ReadOnly =
    zio.aws.config.model.PutExternalEvaluationRequest.wrap(buildAwsValue())
}
object PutExternalEvaluationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutExternalEvaluationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutExternalEvaluationRequest =
      zio.aws.config.model.PutExternalEvaluationRequest(
        configRuleName,
        externalEvaluation.asEditable
      )
    def configRuleName: ConfigRuleName
    def externalEvaluation: zio.aws.config.model.ExternalEvaluation.ReadOnly
    def getConfigRuleName: ZIO[Any, Nothing, ConfigRuleName] =
      ZIO.succeed(configRuleName)
    def getExternalEvaluation
        : ZIO[Any, Nothing, zio.aws.config.model.ExternalEvaluation.ReadOnly] =
      ZIO.succeed(externalEvaluation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutExternalEvaluationRequest
  ) extends zio.aws.config.model.PutExternalEvaluationRequest.ReadOnly {
    override val configRuleName: ConfigRuleName =
      zio.aws.config.model.primitives.ConfigRuleName(impl.configRuleName())
    override val externalEvaluation
        : zio.aws.config.model.ExternalEvaluation.ReadOnly =
      zio.aws.config.model.ExternalEvaluation.wrap(impl.externalEvaluation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutExternalEvaluationRequest
  ): zio.aws.config.model.PutExternalEvaluationRequest.ReadOnly = new Wrapper(
    impl
  )
}
