package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutRemediationExceptionsResponse(
    failedBatches: Optional[
      Iterable[zio.aws.config.model.FailedRemediationExceptionBatch]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutRemediationExceptionsResponse = {
    import PutRemediationExceptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutRemediationExceptionsResponse
      .builder()
      .optionallyWith(
        failedBatches.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedBatches)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.PutRemediationExceptionsResponse.ReadOnly =
    zio.aws.config.model.PutRemediationExceptionsResponse.wrap(buildAwsValue())
}
object PutRemediationExceptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutRemediationExceptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutRemediationExceptionsResponse =
      zio.aws.config.model.PutRemediationExceptionsResponse(
        failedBatches.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failedBatches: Optional[
      List[zio.aws.config.model.FailedRemediationExceptionBatch.ReadOnly]
    ]
    def getFailedBatches: ZIO[Any, AwsError, List[
      zio.aws.config.model.FailedRemediationExceptionBatch.ReadOnly
    ]] = AwsError.unwrapOptionField("failedBatches", failedBatches)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutRemediationExceptionsResponse
  ) extends zio.aws.config.model.PutRemediationExceptionsResponse.ReadOnly {
    override val failedBatches: Optional[
      List[zio.aws.config.model.FailedRemediationExceptionBatch.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failedBatches())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.FailedRemediationExceptionBatch.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutRemediationExceptionsResponse
  ): zio.aws.config.model.PutRemediationExceptionsResponse.ReadOnly =
    new Wrapper(impl)
}
