package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RecordingStrategy(
    useOnly: Optional[zio.aws.config.model.RecordingStrategyType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.RecordingStrategy = {
    import RecordingStrategy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.RecordingStrategy
      .builder()
      .optionallyWith(useOnly.map(value => value.unwrap))(_.useOnly)
      .build()
  }
  def asReadOnly: zio.aws.config.model.RecordingStrategy.ReadOnly =
    zio.aws.config.model.RecordingStrategy.wrap(buildAwsValue())
}
object RecordingStrategy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.RecordingStrategy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.RecordingStrategy =
      zio.aws.config.model.RecordingStrategy(useOnly.map(value => value))
    def useOnly: Optional[zio.aws.config.model.RecordingStrategyType]
    def getUseOnly
        : ZIO[Any, AwsError, zio.aws.config.model.RecordingStrategyType] =
      AwsError.unwrapOptionField("useOnly", useOnly)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.RecordingStrategy
  ) extends zio.aws.config.model.RecordingStrategy.ReadOnly {
    override val useOnly: Optional[zio.aws.config.model.RecordingStrategyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useOnly())
        .map(value => zio.aws.config.model.RecordingStrategyType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.RecordingStrategy
  ): zio.aws.config.model.RecordingStrategy.ReadOnly = new Wrapper(impl)
}
