package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  RelationshipName,
  ResourceName,
  ResourceId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Relationship(
    resourceType: Optional[zio.aws.config.model.ResourceType] = Optional.Absent,
    resourceId: Optional[ResourceId] = Optional.Absent,
    resourceName: Optional[ResourceName] = Optional.Absent,
    relationshipName: Optional[RelationshipName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.Relationship = {
    import Relationship.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.Relationship
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        resourceId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        resourceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.resourceName)
      .optionallyWith(
        relationshipName.map(value =>
          RelationshipName.unwrap(value): java.lang.String
        )
      )(_.relationshipName)
      .build()
  }
  def asReadOnly: zio.aws.config.model.Relationship.ReadOnly =
    zio.aws.config.model.Relationship.wrap(buildAwsValue())
}
object Relationship {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.Relationship
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.Relationship =
      zio.aws.config.model.Relationship(
        resourceType.map(value => value),
        resourceId.map(value => value),
        resourceName.map(value => value),
        relationshipName.map(value => value)
      )
    def resourceType: Optional[zio.aws.config.model.ResourceType]
    def resourceId: Optional[ResourceId]
    def resourceName: Optional[ResourceName]
    def relationshipName: Optional[RelationshipName]
    def getResourceType: ZIO[Any, AwsError, zio.aws.config.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resourceName", resourceName)
    def getRelationshipName: ZIO[Any, AwsError, RelationshipName] =
      AwsError.unwrapOptionField("relationshipName", relationshipName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.Relationship
  ) extends zio.aws.config.model.Relationship.ReadOnly {
    override val resourceType: Optional[zio.aws.config.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.config.model.ResourceType.wrap(value))
    override val resourceId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.config.model.primitives.ResourceId(value))
    override val resourceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceName())
      .map(value => zio.aws.config.model.primitives.ResourceName(value))
    override val relationshipName: Optional[RelationshipName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relationshipName())
        .map(value => zio.aws.config.model.primitives.RelationshipName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.Relationship
  ): zio.aws.config.model.Relationship.ReadOnly = new Wrapper(impl)
}
