package zio.aws.config.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.Date
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class RemediationExecutionStatus(
    resourceKey: Optional[zio.aws.config.model.ResourceKey] = Optional.Absent,
    state: Optional[zio.aws.config.model.RemediationExecutionState] =
      Optional.Absent,
    stepDetails: Optional[
      Iterable[zio.aws.config.model.RemediationExecutionStep]
    ] = Optional.Absent,
    invocationTime: Optional[Date] = Optional.Absent,
    lastUpdatedTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.RemediationExecutionStatus = {
    import RemediationExecutionStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.RemediationExecutionStatus
      .builder()
      .optionallyWith(resourceKey.map(value => value.buildAwsValue()))(
        _.resourceKey
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        stepDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stepDetails)
      .optionallyWith(invocationTime.map(value => Date.unwrap(value): Instant))(
        _.invocationTime
      )
      .optionallyWith(
        lastUpdatedTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .build()
  }
  def asReadOnly: zio.aws.config.model.RemediationExecutionStatus.ReadOnly =
    zio.aws.config.model.RemediationExecutionStatus.wrap(buildAwsValue())
}
object RemediationExecutionStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.RemediationExecutionStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.RemediationExecutionStatus =
      zio.aws.config.model.RemediationExecutionStatus(
        resourceKey.map(value => value.asEditable),
        state.map(value => value),
        stepDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        invocationTime.map(value => value),
        lastUpdatedTime.map(value => value)
      )
    def resourceKey: Optional[zio.aws.config.model.ResourceKey.ReadOnly]
    def state: Optional[zio.aws.config.model.RemediationExecutionState]
    def stepDetails
        : Optional[List[zio.aws.config.model.RemediationExecutionStep.ReadOnly]]
    def invocationTime: Optional[Date]
    def lastUpdatedTime: Optional[Date]
    def getResourceKey
        : ZIO[Any, AwsError, zio.aws.config.model.ResourceKey.ReadOnly] =
      AwsError.unwrapOptionField("resourceKey", resourceKey)
    def getState
        : ZIO[Any, AwsError, zio.aws.config.model.RemediationExecutionState] =
      AwsError.unwrapOptionField("state", state)
    def getStepDetails: ZIO[Any, AwsError, List[
      zio.aws.config.model.RemediationExecutionStep.ReadOnly
    ]] = AwsError.unwrapOptionField("stepDetails", stepDetails)
    def getInvocationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("invocationTime", invocationTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.RemediationExecutionStatus
  ) extends zio.aws.config.model.RemediationExecutionStatus.ReadOnly {
    override val resourceKey
        : Optional[zio.aws.config.model.ResourceKey.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceKey())
        .map(value => zio.aws.config.model.ResourceKey.wrap(value))
    override val state
        : Optional[zio.aws.config.model.RemediationExecutionState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.config.model.RemediationExecutionState.wrap(value)
        )
    override val stepDetails: Optional[
      List[zio.aws.config.model.RemediationExecutionStep.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stepDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.RemediationExecutionStep.wrap(item)
        }.toList
      )
    override val invocationTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.invocationTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val lastUpdatedTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.RemediationExecutionStatus
  ): zio.aws.config.model.RemediationExecutionStatus.ReadOnly = new Wrapper(
    impl
  )
}
