package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait RemediationTargetType {
  def unwrap: software.amazon.awssdk.services.config.model.RemediationTargetType
}
object RemediationTargetType {
  def wrap(
      value: software.amazon.awssdk.services.config.model.RemediationTargetType
  ): zio.aws.config.model.RemediationTargetType = value match {
    case software.amazon.awssdk.services.config.model.RemediationTargetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.RemediationTargetType.SSM_DOCUMENT =>
      val r = SSM_DOCUMENT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.config.model.RemediationTargetType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.RemediationTargetType =
      software.amazon.awssdk.services.config.model.RemediationTargetType.UNKNOWN_TO_SDK_VERSION
  }
  case object SSM_DOCUMENT extends zio.aws.config.model.RemediationTargetType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.RemediationTargetType =
      software.amazon.awssdk.services.config.model.RemediationTargetType.SSM_DOCUMENT
  }
}
