package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceConfigurationSchemaType {
  def unwrap: software.amazon.awssdk.services.config.model.ResourceConfigurationSchemaType
}
object ResourceConfigurationSchemaType {
  def wrap(
      value: software.amazon.awssdk.services.config.model.ResourceConfigurationSchemaType
  ): zio.aws.config.model.ResourceConfigurationSchemaType = value match {
    case software.amazon.awssdk.services.config.model.ResourceConfigurationSchemaType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.ResourceConfigurationSchemaType.CFN_RESOURCE_SCHEMA =>
      val r = CFN_RESOURCE_SCHEMA
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.config.model.ResourceConfigurationSchemaType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceConfigurationSchemaType =
      software.amazon.awssdk.services.config.model.ResourceConfigurationSchemaType.UNKNOWN_TO_SDK_VERSION
  }
  case object CFN_RESOURCE_SCHEMA
      extends zio.aws.config.model.ResourceConfigurationSchemaType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceConfigurationSchemaType =
      software.amazon.awssdk.services.config.model.ResourceConfigurationSchemaType.CFN_RESOURCE_SCHEMA
  }
}
