package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResourceCount(
    resourceType: Optional[zio.aws.config.model.ResourceType] = Optional.Absent,
    count: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ResourceCount = {
    import ResourceCount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ResourceCount
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(count.map(value => value: java.lang.Long))(_.count)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ResourceCount.ReadOnly =
    zio.aws.config.model.ResourceCount.wrap(buildAwsValue())
}
object ResourceCount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ResourceCount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ResourceCount =
      zio.aws.config.model.ResourceCount(
        resourceType.map(value => value),
        count.map(value => value)
      )
    def resourceType: Optional[zio.aws.config.model.ResourceType]
    def count: Optional[Long]
    def getResourceType: ZIO[Any, AwsError, zio.aws.config.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("count", count)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ResourceCount
  ) extends zio.aws.config.model.ResourceCount.ReadOnly {
    override val resourceType: Optional[zio.aws.config.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.config.model.ResourceType.wrap(value))
    override val count: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ResourceCount
  ): zio.aws.config.model.ResourceCount.ReadOnly = new Wrapper(impl)
}
