package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class ResourceKey(
    resourceType: zio.aws.config.model.ResourceType,
    resourceId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ResourceKey = {
    import ResourceKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ResourceKey
      .builder()
      .resourceType(resourceType.unwrap)
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ResourceKey.ReadOnly =
    zio.aws.config.model.ResourceKey.wrap(buildAwsValue())
}
object ResourceKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ResourceKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ResourceKey =
      zio.aws.config.model.ResourceKey(resourceType, resourceId)
    def resourceType: zio.aws.config.model.ResourceType
    def resourceId: ResourceId
    def getResourceType: ZIO[Any, Nothing, zio.aws.config.model.ResourceType] =
      ZIO.succeed(resourceType)
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ResourceKey
  ) extends zio.aws.config.model.ResourceKey.ReadOnly {
    override val resourceType: zio.aws.config.model.ResourceType =
      zio.aws.config.model.ResourceType.wrap(impl.resourceType())
    override val resourceId: ResourceId =
      zio.aws.config.model.primitives.ResourceId(impl.resourceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ResourceKey
  ): zio.aws.config.model.ResourceKey.ReadOnly = new Wrapper(impl)
}
