package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.ConfigRuleName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartConfigRulesEvaluationRequest(
    configRuleNames: Optional[Iterable[ConfigRuleName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationRequest = {
    import StartConfigRulesEvaluationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationRequest
      .builder()
      .optionallyWith(
        configRuleNames.map(value =>
          value.map { item =>
            ConfigRuleName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.configRuleNames)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.StartConfigRulesEvaluationRequest.ReadOnly =
    zio.aws.config.model.StartConfigRulesEvaluationRequest.wrap(buildAwsValue())
}
object StartConfigRulesEvaluationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.StartConfigRulesEvaluationRequest =
      zio.aws.config.model
        .StartConfigRulesEvaluationRequest(configRuleNames.map(value => value))
    def configRuleNames: Optional[List[ConfigRuleName]]
    def getConfigRuleNames: ZIO[Any, AwsError, List[ConfigRuleName]] =
      AwsError.unwrapOptionField("configRuleNames", configRuleNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationRequest
  ) extends zio.aws.config.model.StartConfigRulesEvaluationRequest.ReadOnly {
    override val configRuleNames: Optional[List[ConfigRuleName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configRuleNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.primitives.ConfigRuleName(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationRequest
  ): zio.aws.config.model.StartConfigRulesEvaluationRequest.ReadOnly =
    new Wrapper(impl)
}
