package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.ConfigRuleName
import scala.jdk.CollectionConverters.*
final case class StartRemediationExecutionRequest(
    configRuleName: ConfigRuleName,
    resourceKeys: Iterable[zio.aws.config.model.ResourceKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.StartRemediationExecutionRequest = {
    import StartRemediationExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.StartRemediationExecutionRequest
      .builder()
      .configRuleName(ConfigRuleName.unwrap(configRuleName): java.lang.String)
      .resourceKeys(resourceKeys.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.StartRemediationExecutionRequest.ReadOnly =
    zio.aws.config.model.StartRemediationExecutionRequest.wrap(buildAwsValue())
}
object StartRemediationExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.StartRemediationExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.StartRemediationExecutionRequest =
      zio.aws.config.model.StartRemediationExecutionRequest(
        configRuleName,
        resourceKeys.map { item =>
          item.asEditable
        }
      )
    def configRuleName: ConfigRuleName
    def resourceKeys: List[zio.aws.config.model.ResourceKey.ReadOnly]
    def getConfigRuleName: ZIO[Any, Nothing, ConfigRuleName] =
      ZIO.succeed(configRuleName)
    def getResourceKeys
        : ZIO[Any, Nothing, List[zio.aws.config.model.ResourceKey.ReadOnly]] =
      ZIO.succeed(resourceKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.StartRemediationExecutionRequest
  ) extends zio.aws.config.model.StartRemediationExecutionRequest.ReadOnly {
    override val configRuleName: ConfigRuleName =
      zio.aws.config.model.primitives.ConfigRuleName(impl.configRuleName())
    override val resourceKeys: List[zio.aws.config.model.ResourceKey.ReadOnly] =
      impl
        .resourceKeys()
        .asScala
        .map { item =>
          zio.aws.config.model.ResourceKey.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.StartRemediationExecutionRequest
  ): zio.aws.config.model.StartRemediationExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
