package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.StringWithCharLimit256
import scala.jdk.CollectionConverters.*
final case class StaticValue(values: Iterable[StringWithCharLimit256]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.StaticValue = {
    import StaticValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.StaticValue
      .builder()
      .values(values.map { item =>
        StringWithCharLimit256.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.config.model.StaticValue.ReadOnly =
    zio.aws.config.model.StaticValue.wrap(buildAwsValue())
}
object StaticValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.StaticValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.StaticValue =
      zio.aws.config.model.StaticValue(values)
    def values: List[StringWithCharLimit256]
    def getValues: ZIO[Any, Nothing, List[StringWithCharLimit256]] =
      ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.StaticValue
  ) extends zio.aws.config.model.StaticValue.ReadOnly {
    override val values: List[StringWithCharLimit256] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.config.model.primitives.StringWithCharLimit256(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.StaticValue
  ): zio.aws.config.model.StaticValue.ReadOnly = new Wrapper(impl)
}
