package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.connect.model.primitives.{Timestamp, AgentResourceId}
import scala.jdk.CollectionConverters._
final case class AgentInfo(
    id: Option[AgentResourceId] = None,
    connectedToAgentTimestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.AgentInfo = {
    import AgentInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.AgentInfo
      .builder()
      .optionallyWith(
        id.map(value => AgentResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        connectedToAgentTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.connectedToAgentTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.AgentInfo.ReadOnly =
    zio.aws.connect.model.AgentInfo.wrap(buildAwsValue())
}
object AgentInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.AgentInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.AgentInfo =
      zio.aws.connect.model.AgentInfo(
        id.map(value => value),
        connectedToAgentTimestamp.map(value => value)
      )
    def id: Option[AgentResourceId]
    def connectedToAgentTimestamp: Option[Timestamp]
    def getId: ZIO[Any, AwsError, AgentResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getConnectedToAgentTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("connectedToAgentTimestamp", connectedToAgentTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.AgentInfo
  ) extends zio.aws.connect.model.AgentInfo.ReadOnly {
    override val id: Option[AgentResourceId] = scala
      .Option(impl.id())
      .map(value => zio.aws.connect.model.primitives.AgentResourceId(value))
    override val connectedToAgentTimestamp: Option[Timestamp] = scala
      .Option(impl.connectedToAgentTimestamp())
      .map(value => zio.aws.connect.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.AgentInfo
  ): zio.aws.connect.model.AgentInfo.ReadOnly = new Wrapper(impl)
}
