package zio.aws.connect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  AgentStatusId,
  TagValue,
  AgentStatusName,
  AgentStatusOrderNumber,
  AgentStatusDescription,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class AgentStatus(
    agentStatusARN: Option[ARN] = None,
    agentStatusId: Option[AgentStatusId] = None,
    name: Option[AgentStatusName] = None,
    description: Option[AgentStatusDescription] = None,
    `type`: Option[zio.aws.connect.model.AgentStatusType] = None,
    displayOrder: Option[AgentStatusOrderNumber] = None,
    state: Option[zio.aws.connect.model.AgentStatusState] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.AgentStatus = {
    import AgentStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.AgentStatus
      .builder()
      .optionallyWith(
        agentStatusARN.map(value => ARN.unwrap(value): java.lang.String)
      )(_.agentStatusARN)
      .optionallyWith(
        agentStatusId.map(value =>
          AgentStatusId.unwrap(value): java.lang.String
        )
      )(_.agentStatusId)
      .optionallyWith(
        name.map(value => AgentStatusName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          AgentStatusDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        displayOrder.map(value => AgentStatusOrderNumber.unwrap(value): Integer)
      )(_.displayOrder)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.AgentStatus.ReadOnly =
    zio.aws.connect.model.AgentStatus.wrap(buildAwsValue())
}
object AgentStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.AgentStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.AgentStatus =
      zio.aws.connect.model.AgentStatus(
        agentStatusARN.map(value => value),
        agentStatusId.map(value => value),
        name.map(value => value),
        description.map(value => value),
        `type`.map(value => value),
        displayOrder.map(value => value),
        state.map(value => value),
        tags.map(value => value)
      )
    def agentStatusARN: Option[ARN]
    def agentStatusId: Option[AgentStatusId]
    def name: Option[AgentStatusName]
    def description: Option[AgentStatusDescription]
    def `type`: Option[zio.aws.connect.model.AgentStatusType]
    def displayOrder: Option[AgentStatusOrderNumber]
    def state: Option[zio.aws.connect.model.AgentStatusState]
    def tags: Option[Map[TagKey, TagValue]]
    def getAgentStatusARN: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("agentStatusARN", agentStatusARN)
    def getAgentStatusId: ZIO[Any, AwsError, AgentStatusId] =
      AwsError.unwrapOptionField("agentStatusId", agentStatusId)
    def getName: ZIO[Any, AwsError, AgentStatusName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, AgentStatusDescription] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, AwsError, zio.aws.connect.model.AgentStatusType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDisplayOrder: ZIO[Any, AwsError, AgentStatusOrderNumber] =
      AwsError.unwrapOptionField("displayOrder", displayOrder)
    def getState: ZIO[Any, AwsError, zio.aws.connect.model.AgentStatusState] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.AgentStatus
  ) extends zio.aws.connect.model.AgentStatus.ReadOnly {
    override val agentStatusARN: Option[ARN] = scala
      .Option(impl.agentStatusARN())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val agentStatusId: Option[AgentStatusId] = scala
      .Option(impl.agentStatusId())
      .map(value => zio.aws.connect.model.primitives.AgentStatusId(value))
    override val name: Option[AgentStatusName] = scala
      .Option(impl.name())
      .map(value => zio.aws.connect.model.primitives.AgentStatusName(value))
    override val description: Option[AgentStatusDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.connect.model.primitives.AgentStatusDescription(value)
      )
    override val `type`: Option[zio.aws.connect.model.AgentStatusType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.connect.model.AgentStatusType.wrap(value))
    override val displayOrder: Option[AgentStatusOrderNumber] = scala
      .Option(impl.displayOrder())
      .map(value =>
        zio.aws.connect.model.primitives.AgentStatusOrderNumber(value)
      )
    override val state: Option[zio.aws.connect.model.AgentStatusState] = scala
      .Option(impl.state())
      .map(value => zio.aws.connect.model.AgentStatusState.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.AgentStatus
  ): zio.aws.connect.model.AgentStatus.ReadOnly = new Wrapper(impl)
}
