package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait AgentStatusState {
  def unwrap: software.amazon.awssdk.services.connect.model.AgentStatusState
}
object AgentStatusState {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.AgentStatusState
  ): zio.aws.connect.model.AgentStatusState = value match {
    case software.amazon.awssdk.services.connect.model.AgentStatusState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.AgentStatusState.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.connect.model.AgentStatusState.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.AgentStatusState {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.AgentStatusState =
      software.amazon.awssdk.services.connect.model.AgentStatusState.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.connect.model.AgentStatusState {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.AgentStatusState =
      software.amazon.awssdk.services.connect.model.AgentStatusState.ENABLED
  }
  case object DISABLED extends zio.aws.connect.model.AgentStatusState {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.AgentStatusState =
      software.amazon.awssdk.services.connect.model.AgentStatusState.DISABLED
  }
}
