package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{AgentStatusName, ARN, AgentStatusId}
import scala.jdk.CollectionConverters._
final case class AgentStatusSummary(
    id: Option[AgentStatusId] = None,
    arn: Option[ARN] = None,
    name: Option[AgentStatusName] = None,
    `type`: Option[zio.aws.connect.model.AgentStatusType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.AgentStatusSummary = {
    import AgentStatusSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.AgentStatusSummary
      .builder()
      .optionallyWith(
        id.map(value => AgentStatusId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => AgentStatusName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.AgentStatusSummary.ReadOnly =
    zio.aws.connect.model.AgentStatusSummary.wrap(buildAwsValue())
}
object AgentStatusSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.AgentStatusSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.AgentStatusSummary =
      zio.aws.connect.model.AgentStatusSummary(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        `type`.map(value => value)
      )
    def id: Option[AgentStatusId]
    def arn: Option[ARN]
    def name: Option[AgentStatusName]
    def `type`: Option[zio.aws.connect.model.AgentStatusType]
    def getId: ZIO[Any, AwsError, AgentStatusId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, AgentStatusName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.connect.model.AgentStatusType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.AgentStatusSummary
  ) extends zio.aws.connect.model.AgentStatusSummary.ReadOnly {
    override val id: Option[AgentStatusId] = scala
      .Option(impl.id())
      .map(value => zio.aws.connect.model.primitives.AgentStatusId(value))
    override val arn: Option[ARN] = scala
      .Option(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val name: Option[AgentStatusName] = scala
      .Option(impl.name())
      .map(value => zio.aws.connect.model.primitives.AgentStatusName(value))
    override val `type`: Option[zio.aws.connect.model.AgentStatusType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.connect.model.AgentStatusType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.AgentStatusSummary
  ): zio.aws.connect.model.AgentStatusSummary.ReadOnly = new Wrapper(impl)
}
