package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AnswerMachineDetectionConfig(
    enableAnswerMachineDetection: Option[Boolean] = None,
    awaitAnswerMachinePrompt: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.AnswerMachineDetectionConfig = {
    import AnswerMachineDetectionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.AnswerMachineDetectionConfig
      .builder()
      .optionallyWith(
        enableAnswerMachineDetection.map(value => value: java.lang.Boolean)
      )(_.enableAnswerMachineDetection)
      .optionallyWith(
        awaitAnswerMachinePrompt.map(value => value: java.lang.Boolean)
      )(_.awaitAnswerMachinePrompt)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.AnswerMachineDetectionConfig.ReadOnly =
    zio.aws.connect.model.AnswerMachineDetectionConfig.wrap(buildAwsValue())
}
object AnswerMachineDetectionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.AnswerMachineDetectionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.AnswerMachineDetectionConfig =
      zio.aws.connect.model.AnswerMachineDetectionConfig(
        enableAnswerMachineDetection.map(value => value),
        awaitAnswerMachinePrompt.map(value => value)
      )
    def enableAnswerMachineDetection: Option[Boolean]
    def awaitAnswerMachinePrompt: Option[Boolean]
    def getEnableAnswerMachineDetection: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableAnswerMachineDetection",
        enableAnswerMachineDetection
      )
    def getAwaitAnswerMachinePrompt: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("awaitAnswerMachinePrompt", awaitAnswerMachinePrompt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.AnswerMachineDetectionConfig
  ) extends zio.aws.connect.model.AnswerMachineDetectionConfig.ReadOnly {
    override val enableAnswerMachineDetection: Option[Boolean] = scala
      .Option(impl.enableAnswerMachineDetection())
      .map(value => value: Boolean)
    override val awaitAnswerMachinePrompt: Option[Boolean] =
      scala.Option(impl.awaitAnswerMachinePrompt()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.AnswerMachineDetectionConfig
  ): zio.aws.connect.model.AnswerMachineDetectionConfig.ReadOnly = new Wrapper(
    impl
  )
}
