package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.InstanceId
import scala.jdk.CollectionConverters._
final case class AssociateBotRequest(
    instanceId: InstanceId,
    lexBot: Option[zio.aws.connect.model.LexBot] = None,
    lexV2Bot: Option[zio.aws.connect.model.LexV2Bot] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.AssociateBotRequest = {
    import AssociateBotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.AssociateBotRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(lexBot.map(value => value.buildAwsValue()))(_.lexBot)
      .optionallyWith(lexV2Bot.map(value => value.buildAwsValue()))(_.lexV2Bot)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.AssociateBotRequest.ReadOnly =
    zio.aws.connect.model.AssociateBotRequest.wrap(buildAwsValue())
}
object AssociateBotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.AssociateBotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.AssociateBotRequest =
      zio.aws.connect.model.AssociateBotRequest(
        instanceId,
        lexBot.map(value => value.asEditable),
        lexV2Bot.map(value => value.asEditable)
      )
    def instanceId: InstanceId
    def lexBot: Option[zio.aws.connect.model.LexBot.ReadOnly]
    def lexV2Bot: Option[zio.aws.connect.model.LexV2Bot.ReadOnly]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getLexBot: ZIO[Any, AwsError, zio.aws.connect.model.LexBot.ReadOnly] =
      AwsError.unwrapOptionField("lexBot", lexBot)
    def getLexV2Bot
        : ZIO[Any, AwsError, zio.aws.connect.model.LexV2Bot.ReadOnly] =
      AwsError.unwrapOptionField("lexV2Bot", lexV2Bot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.AssociateBotRequest
  ) extends zio.aws.connect.model.AssociateBotRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val lexBot: Option[zio.aws.connect.model.LexBot.ReadOnly] = scala
      .Option(impl.lexBot())
      .map(value => zio.aws.connect.model.LexBot.wrap(value))
    override val lexV2Bot: Option[zio.aws.connect.model.LexV2Bot.ReadOnly] =
      scala
        .Option(impl.lexV2Bot())
        .map(value => zio.aws.connect.model.LexV2Bot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.AssociateBotRequest
  ): zio.aws.connect.model.AssociateBotRequest.ReadOnly = new Wrapper(impl)
}
