package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.AssociationId
import scala.jdk.CollectionConverters._
final case class AssociateInstanceStorageConfigResponse(
    associationId: Option[AssociationId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.AssociateInstanceStorageConfigResponse = {
    import AssociateInstanceStorageConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.AssociateInstanceStorageConfigResponse
      .builder()
      .optionallyWith(
        associationId.map(value =>
          AssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.AssociateInstanceStorageConfigResponse.ReadOnly =
    zio.aws.connect.model.AssociateInstanceStorageConfigResponse
      .wrap(buildAwsValue())
}
object AssociateInstanceStorageConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.AssociateInstanceStorageConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.AssociateInstanceStorageConfigResponse =
      zio.aws.connect.model.AssociateInstanceStorageConfigResponse(
        associationId.map(value => value)
      )
    def associationId: Option[AssociationId]
    def getAssociationId: ZIO[Any, AwsError, AssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.AssociateInstanceStorageConfigResponse
  ) extends zio.aws.connect.model.AssociateInstanceStorageConfigResponse.ReadOnly {
    override val associationId: Option[AssociationId] = scala
      .Option(impl.associationId())
      .map(value => zio.aws.connect.model.primitives.AssociationId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.AssociateInstanceStorageConfigResponse
  ): zio.aws.connect.model.AssociateInstanceStorageConfigResponse.ReadOnly =
    new Wrapper(impl)
}
