package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.InstanceId
import scala.jdk.CollectionConverters._
final case class AssociateLexBotRequest(
    instanceId: InstanceId,
    lexBot: zio.aws.connect.model.LexBot
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.AssociateLexBotRequest = {
    import AssociateLexBotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.AssociateLexBotRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .lexBot(lexBot.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.connect.model.AssociateLexBotRequest.ReadOnly =
    zio.aws.connect.model.AssociateLexBotRequest.wrap(buildAwsValue())
}
object AssociateLexBotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.AssociateLexBotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.AssociateLexBotRequest =
      zio.aws.connect.model
        .AssociateLexBotRequest(instanceId, lexBot.asEditable)
    def instanceId: InstanceId
    def lexBot: zio.aws.connect.model.LexBot.ReadOnly
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getLexBot: ZIO[Any, Nothing, zio.aws.connect.model.LexBot.ReadOnly] =
      ZIO.succeed(lexBot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.AssociateLexBotRequest
  ) extends zio.aws.connect.model.AssociateLexBotRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val lexBot: zio.aws.connect.model.LexBot.ReadOnly =
      zio.aws.connect.model.LexBot.wrap(impl.lexBot())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.AssociateLexBotRequest
  ): zio.aws.connect.model.AssociateLexBotRequest.ReadOnly = new Wrapper(impl)
}
