package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{PEM, InstanceId}
import scala.jdk.CollectionConverters._
final case class AssociateSecurityKeyRequest(instanceId: InstanceId, key: PEM) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.AssociateSecurityKeyRequest = {
    import AssociateSecurityKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.AssociateSecurityKeyRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .key(PEM.unwrap(key): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.AssociateSecurityKeyRequest.ReadOnly =
    zio.aws.connect.model.AssociateSecurityKeyRequest.wrap(buildAwsValue())
}
object AssociateSecurityKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.AssociateSecurityKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.AssociateSecurityKeyRequest =
      zio.aws.connect.model.AssociateSecurityKeyRequest(instanceId, key)
    def instanceId: InstanceId
    def key: PEM
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getKey: ZIO[Any, Nothing, PEM] = ZIO.succeed(key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.AssociateSecurityKeyRequest
  ) extends zio.aws.connect.model.AssociateSecurityKeyRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val key: PEM = zio.aws.connect.model.primitives.PEM(impl.key())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.AssociateSecurityKeyRequest
  ): zio.aws.connect.model.AssociateSecurityKeyRequest.ReadOnly = new Wrapper(
    impl
  )
}
