package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{ReferenceValue, ReferenceKey}
import scala.jdk.CollectionConverters._
final case class AttachmentReference(
    name: Option[ReferenceKey] = None,
    value: Option[ReferenceValue] = None,
    status: Option[zio.aws.connect.model.ReferenceStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.AttachmentReference = {
    import AttachmentReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.AttachmentReference
      .builder()
      .optionallyWith(
        name.map(value => ReferenceKey.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        value.map(value => ReferenceValue.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.AttachmentReference.ReadOnly =
    zio.aws.connect.model.AttachmentReference.wrap(buildAwsValue())
}
object AttachmentReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.AttachmentReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.AttachmentReference =
      zio.aws.connect.model.AttachmentReference(
        name.map(value => value),
        value.map(value => value),
        status.map(value => value)
      )
    def name: Option[ReferenceKey]
    def value: Option[ReferenceValue]
    def status: Option[zio.aws.connect.model.ReferenceStatus]
    def getName: ZIO[Any, AwsError, ReferenceKey] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, ReferenceValue] =
      AwsError.unwrapOptionField("value", value)
    def getStatus: ZIO[Any, AwsError, zio.aws.connect.model.ReferenceStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.AttachmentReference
  ) extends zio.aws.connect.model.AttachmentReference.ReadOnly {
    override val name: Option[ReferenceKey] = scala
      .Option(impl.name())
      .map(value => zio.aws.connect.model.primitives.ReferenceKey(value))
    override val value: Option[ReferenceValue] = scala
      .Option(impl.value())
      .map(value => zio.aws.connect.model.primitives.ReferenceValue(value))
    override val status: Option[zio.aws.connect.model.ReferenceStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.connect.model.ReferenceStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.AttachmentReference
  ): zio.aws.connect.model.AttachmentReference.ReadOnly = new Wrapper(impl)
}
