package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.connect.model.primitives.{
  Timestamp,
  Description,
  ContactId,
  Name,
  ARN
}
import scala.jdk.CollectionConverters._
final case class Contact(
    arn: Option[ARN] = None,
    id: Option[ContactId] = None,
    initialContactId: Option[ContactId] = None,
    previousContactId: Option[ContactId] = None,
    initiationMethod: Option[zio.aws.connect.model.ContactInitiationMethod] =
      None,
    name: Option[Name] = None,
    description: Option[Description] = None,
    channel: Option[zio.aws.connect.model.Channel] = None,
    queueInfo: Option[zio.aws.connect.model.QueueInfo] = None,
    agentInfo: Option[zio.aws.connect.model.AgentInfo] = None,
    initiationTimestamp: Option[Timestamp] = None,
    disconnectTimestamp: Option[Timestamp] = None,
    lastUpdateTimestamp: Option[Timestamp] = None,
    scheduledTimestamp: Option[Timestamp] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.connect.model.Contact = {
    import Contact.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.Contact
      .builder()
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        id.map(value => ContactId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        initialContactId.map(value => ContactId.unwrap(value): java.lang.String)
      )(_.initialContactId)
      .optionallyWith(
        previousContactId.map(value =>
          ContactId.unwrap(value): java.lang.String
        )
      )(_.previousContactId)
      .optionallyWith(initiationMethod.map(value => value.unwrap))(
        _.initiationMethod
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(channel.map(value => value.unwrap))(_.channel)
      .optionallyWith(queueInfo.map(value => value.buildAwsValue()))(
        _.queueInfo
      )
      .optionallyWith(agentInfo.map(value => value.buildAwsValue()))(
        _.agentInfo
      )
      .optionallyWith(
        initiationTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.initiationTimestamp)
      .optionallyWith(
        disconnectTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.disconnectTimestamp)
      .optionallyWith(
        lastUpdateTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTimestamp)
      .optionallyWith(
        scheduledTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.scheduledTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.Contact.ReadOnly =
    zio.aws.connect.model.Contact.wrap(buildAwsValue())
}
object Contact {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.Contact] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.Contact =
      zio.aws.connect.model.Contact(
        arn.map(value => value),
        id.map(value => value),
        initialContactId.map(value => value),
        previousContactId.map(value => value),
        initiationMethod.map(value => value),
        name.map(value => value),
        description.map(value => value),
        channel.map(value => value),
        queueInfo.map(value => value.asEditable),
        agentInfo.map(value => value.asEditable),
        initiationTimestamp.map(value => value),
        disconnectTimestamp.map(value => value),
        lastUpdateTimestamp.map(value => value),
        scheduledTimestamp.map(value => value)
      )
    def arn: Option[ARN]
    def id: Option[ContactId]
    def initialContactId: Option[ContactId]
    def previousContactId: Option[ContactId]
    def initiationMethod: Option[zio.aws.connect.model.ContactInitiationMethod]
    def name: Option[Name]
    def description: Option[Description]
    def channel: Option[zio.aws.connect.model.Channel]
    def queueInfo: Option[zio.aws.connect.model.QueueInfo.ReadOnly]
    def agentInfo: Option[zio.aws.connect.model.AgentInfo.ReadOnly]
    def initiationTimestamp: Option[Timestamp]
    def disconnectTimestamp: Option[Timestamp]
    def lastUpdateTimestamp: Option[Timestamp]
    def scheduledTimestamp: Option[Timestamp]
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, ContactId] =
      AwsError.unwrapOptionField("id", id)
    def getInitialContactId: ZIO[Any, AwsError, ContactId] =
      AwsError.unwrapOptionField("initialContactId", initialContactId)
    def getPreviousContactId: ZIO[Any, AwsError, ContactId] =
      AwsError.unwrapOptionField("previousContactId", previousContactId)
    def getInitiationMethod
        : ZIO[Any, AwsError, zio.aws.connect.model.ContactInitiationMethod] =
      AwsError.unwrapOptionField("initiationMethod", initiationMethod)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getChannel: ZIO[Any, AwsError, zio.aws.connect.model.Channel] =
      AwsError.unwrapOptionField("channel", channel)
    def getQueueInfo
        : ZIO[Any, AwsError, zio.aws.connect.model.QueueInfo.ReadOnly] =
      AwsError.unwrapOptionField("queueInfo", queueInfo)
    def getAgentInfo
        : ZIO[Any, AwsError, zio.aws.connect.model.AgentInfo.ReadOnly] =
      AwsError.unwrapOptionField("agentInfo", agentInfo)
    def getInitiationTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("initiationTimestamp", initiationTimestamp)
    def getDisconnectTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("disconnectTimestamp", disconnectTimestamp)
    def getLastUpdateTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTimestamp", lastUpdateTimestamp)
    def getScheduledTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("scheduledTimestamp", scheduledTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.Contact
  ) extends zio.aws.connect.model.Contact.ReadOnly {
    override val arn: Option[ARN] = scala
      .Option(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val id: Option[ContactId] = scala
      .Option(impl.id())
      .map(value => zio.aws.connect.model.primitives.ContactId(value))
    override val initialContactId: Option[ContactId] = scala
      .Option(impl.initialContactId())
      .map(value => zio.aws.connect.model.primitives.ContactId(value))
    override val previousContactId: Option[ContactId] = scala
      .Option(impl.previousContactId())
      .map(value => zio.aws.connect.model.primitives.ContactId(value))
    override val initiationMethod
        : Option[zio.aws.connect.model.ContactInitiationMethod] = scala
      .Option(impl.initiationMethod())
      .map(value => zio.aws.connect.model.ContactInitiationMethod.wrap(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.connect.model.primitives.Name(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.connect.model.primitives.Description(value))
    override val channel: Option[zio.aws.connect.model.Channel] = scala
      .Option(impl.channel())
      .map(value => zio.aws.connect.model.Channel.wrap(value))
    override val queueInfo: Option[zio.aws.connect.model.QueueInfo.ReadOnly] =
      scala
        .Option(impl.queueInfo())
        .map(value => zio.aws.connect.model.QueueInfo.wrap(value))
    override val agentInfo: Option[zio.aws.connect.model.AgentInfo.ReadOnly] =
      scala
        .Option(impl.agentInfo())
        .map(value => zio.aws.connect.model.AgentInfo.wrap(value))
    override val initiationTimestamp: Option[Timestamp] = scala
      .Option(impl.initiationTimestamp())
      .map(value => zio.aws.connect.model.primitives.Timestamp(value))
    override val disconnectTimestamp: Option[Timestamp] = scala
      .Option(impl.disconnectTimestamp())
      .map(value => zio.aws.connect.model.primitives.Timestamp(value))
    override val lastUpdateTimestamp: Option[Timestamp] = scala
      .Option(impl.lastUpdateTimestamp())
      .map(value => zio.aws.connect.model.primitives.Timestamp(value))
    override val scheduledTimestamp: Option[Timestamp] = scala
      .Option(impl.scheduledTimestamp())
      .map(value => zio.aws.connect.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.Contact
  ): zio.aws.connect.model.Contact.ReadOnly = new Wrapper(impl)
}
