package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  ContactFlowDescription,
  TagValue,
  ContactFlowName,
  ContactFlowContent,
  ContactFlowId,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class ContactFlow(
    arn: Option[ARN] = None,
    id: Option[ContactFlowId] = None,
    name: Option[ContactFlowName] = None,
    `type`: Option[zio.aws.connect.model.ContactFlowType] = None,
    state: Option[zio.aws.connect.model.ContactFlowState] = None,
    description: Option[ContactFlowDescription] = None,
    content: Option[ContactFlowContent] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ContactFlow = {
    import ContactFlow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ContactFlow
      .builder()
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        id.map(value => ContactFlowId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => ContactFlowName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        description.map(value =>
          ContactFlowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        content.map(value => ContactFlowContent.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ContactFlow.ReadOnly =
    zio.aws.connect.model.ContactFlow.wrap(buildAwsValue())
}
object ContactFlow {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ContactFlow
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ContactFlow =
      zio.aws.connect.model.ContactFlow(
        arn.map(value => value),
        id.map(value => value),
        name.map(value => value),
        `type`.map(value => value),
        state.map(value => value),
        description.map(value => value),
        content.map(value => value),
        tags.map(value => value)
      )
    def arn: Option[ARN]
    def id: Option[ContactFlowId]
    def name: Option[ContactFlowName]
    def `type`: Option[zio.aws.connect.model.ContactFlowType]
    def state: Option[zio.aws.connect.model.ContactFlowState]
    def description: Option[ContactFlowDescription]
    def content: Option[ContactFlowContent]
    def tags: Option[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, ContactFlowId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ContactFlowName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.connect.model.ContactFlowType] =
      AwsError.unwrapOptionField("type", `type`)
    def getState: ZIO[Any, AwsError, zio.aws.connect.model.ContactFlowState] =
      AwsError.unwrapOptionField("state", state)
    def getDescription: ZIO[Any, AwsError, ContactFlowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getContent: ZIO[Any, AwsError, ContactFlowContent] =
      AwsError.unwrapOptionField("content", content)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ContactFlow
  ) extends zio.aws.connect.model.ContactFlow.ReadOnly {
    override val arn: Option[ARN] = scala
      .Option(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val id: Option[ContactFlowId] = scala
      .Option(impl.id())
      .map(value => zio.aws.connect.model.primitives.ContactFlowId(value))
    override val name: Option[ContactFlowName] = scala
      .Option(impl.name())
      .map(value => zio.aws.connect.model.primitives.ContactFlowName(value))
    override val `type`: Option[zio.aws.connect.model.ContactFlowType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.connect.model.ContactFlowType.wrap(value))
    override val state: Option[zio.aws.connect.model.ContactFlowState] = scala
      .Option(impl.state())
      .map(value => zio.aws.connect.model.ContactFlowState.wrap(value))
    override val description: Option[ContactFlowDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.connect.model.primitives.ContactFlowDescription(value)
      )
    override val content: Option[ContactFlowContent] = scala
      .Option(impl.content())
      .map(value => zio.aws.connect.model.primitives.ContactFlowContent(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ContactFlow
  ): zio.aws.connect.model.ContactFlow.ReadOnly = new Wrapper(impl)
}
