package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  ContactFlowModuleName,
  ContactFlowModuleDescription,
  TagValue,
  ContactFlowModuleId,
  ContactFlowModuleContent,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class ContactFlowModule(
    arn: Option[ARN] = None,
    id: Option[ContactFlowModuleId] = None,
    name: Option[ContactFlowModuleName] = None,
    content: Option[ContactFlowModuleContent] = None,
    description: Option[ContactFlowModuleDescription] = None,
    state: Option[zio.aws.connect.model.ContactFlowModuleState] = None,
    status: Option[zio.aws.connect.model.ContactFlowModuleStatus] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ContactFlowModule = {
    import ContactFlowModule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ContactFlowModule
      .builder()
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        id.map(value => ContactFlowModuleId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => ContactFlowModuleName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        content.map(value =>
          ContactFlowModuleContent.unwrap(value): java.lang.String
        )
      )(_.content)
      .optionallyWith(
        description.map(value =>
          ContactFlowModuleDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ContactFlowModule.ReadOnly =
    zio.aws.connect.model.ContactFlowModule.wrap(buildAwsValue())
}
object ContactFlowModule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ContactFlowModule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ContactFlowModule =
      zio.aws.connect.model.ContactFlowModule(
        arn.map(value => value),
        id.map(value => value),
        name.map(value => value),
        content.map(value => value),
        description.map(value => value),
        state.map(value => value),
        status.map(value => value),
        tags.map(value => value)
      )
    def arn: Option[ARN]
    def id: Option[ContactFlowModuleId]
    def name: Option[ContactFlowModuleName]
    def content: Option[ContactFlowModuleContent]
    def description: Option[ContactFlowModuleDescription]
    def state: Option[zio.aws.connect.model.ContactFlowModuleState]
    def status: Option[zio.aws.connect.model.ContactFlowModuleStatus]
    def tags: Option[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, ContactFlowModuleId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ContactFlowModuleName] =
      AwsError.unwrapOptionField("name", name)
    def getContent: ZIO[Any, AwsError, ContactFlowModuleContent] =
      AwsError.unwrapOptionField("content", content)
    def getDescription: ZIO[Any, AwsError, ContactFlowModuleDescription] =
      AwsError.unwrapOptionField("description", description)
    def getState
        : ZIO[Any, AwsError, zio.aws.connect.model.ContactFlowModuleState] =
      AwsError.unwrapOptionField("state", state)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.connect.model.ContactFlowModuleStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ContactFlowModule
  ) extends zio.aws.connect.model.ContactFlowModule.ReadOnly {
    override val arn: Option[ARN] = scala
      .Option(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val id: Option[ContactFlowModuleId] = scala
      .Option(impl.id())
      .map(value => zio.aws.connect.model.primitives.ContactFlowModuleId(value))
    override val name: Option[ContactFlowModuleName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.connect.model.primitives.ContactFlowModuleName(value)
      )
    override val content: Option[ContactFlowModuleContent] = scala
      .Option(impl.content())
      .map(value =>
        zio.aws.connect.model.primitives.ContactFlowModuleContent(value)
      )
    override val description: Option[ContactFlowModuleDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.connect.model.primitives.ContactFlowModuleDescription(value)
      )
    override val state: Option[zio.aws.connect.model.ContactFlowModuleState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.connect.model.ContactFlowModuleState.wrap(value))
    override val status: Option[zio.aws.connect.model.ContactFlowModuleStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.connect.model.ContactFlowModuleStatus.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ContactFlowModule
  ): zio.aws.connect.model.ContactFlowModule.ReadOnly = new Wrapper(impl)
}
