package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait ContactFlowModuleState {
  def unwrap
      : software.amazon.awssdk.services.connect.model.ContactFlowModuleState
}
object ContactFlowModuleState {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.ContactFlowModuleState
  ): zio.aws.connect.model.ContactFlowModuleState = value match {
    case software.amazon.awssdk.services.connect.model.ContactFlowModuleState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.ContactFlowModuleState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.connect.model.ContactFlowModuleState.ARCHIVED =>
      val r = ARCHIVED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.ContactFlowModuleState {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactFlowModuleState =
      software.amazon.awssdk.services.connect.model.ContactFlowModuleState.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.connect.model.ContactFlowModuleState {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactFlowModuleState =
      software.amazon.awssdk.services.connect.model.ContactFlowModuleState.ACTIVE
  }
  case object ARCHIVED extends zio.aws.connect.model.ContactFlowModuleState {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactFlowModuleState =
      software.amazon.awssdk.services.connect.model.ContactFlowModuleState.ARCHIVED
  }
}
