package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  ContactFlowModuleName,
  ARN,
  ContactFlowModuleId
}
import scala.jdk.CollectionConverters._
final case class ContactFlowModuleSummary(
    id: Option[ContactFlowModuleId] = None,
    arn: Option[ARN] = None,
    name: Option[ContactFlowModuleName] = None,
    state: Option[zio.aws.connect.model.ContactFlowModuleState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ContactFlowModuleSummary = {
    import ContactFlowModuleSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ContactFlowModuleSummary
      .builder()
      .optionallyWith(
        id.map(value => ContactFlowModuleId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => ContactFlowModuleName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ContactFlowModuleSummary.ReadOnly =
    zio.aws.connect.model.ContactFlowModuleSummary.wrap(buildAwsValue())
}
object ContactFlowModuleSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ContactFlowModuleSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ContactFlowModuleSummary =
      zio.aws.connect.model.ContactFlowModuleSummary(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        state.map(value => value)
      )
    def id: Option[ContactFlowModuleId]
    def arn: Option[ARN]
    def name: Option[ContactFlowModuleName]
    def state: Option[zio.aws.connect.model.ContactFlowModuleState]
    def getId: ZIO[Any, AwsError, ContactFlowModuleId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ContactFlowModuleName] =
      AwsError.unwrapOptionField("name", name)
    def getState
        : ZIO[Any, AwsError, zio.aws.connect.model.ContactFlowModuleState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ContactFlowModuleSummary
  ) extends zio.aws.connect.model.ContactFlowModuleSummary.ReadOnly {
    override val id: Option[ContactFlowModuleId] = scala
      .Option(impl.id())
      .map(value => zio.aws.connect.model.primitives.ContactFlowModuleId(value))
    override val arn: Option[ARN] = scala
      .Option(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val name: Option[ContactFlowModuleName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.connect.model.primitives.ContactFlowModuleName(value)
      )
    override val state: Option[zio.aws.connect.model.ContactFlowModuleState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.connect.model.ContactFlowModuleState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ContactFlowModuleSummary
  ): zio.aws.connect.model.ContactFlowModuleSummary.ReadOnly = new Wrapper(impl)
}
