package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait ContactInitiationMethod {
  def unwrap
      : software.amazon.awssdk.services.connect.model.ContactInitiationMethod
}
object ContactInitiationMethod {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.ContactInitiationMethod
  ): zio.aws.connect.model.ContactInitiationMethod = value match {
    case software.amazon.awssdk.services.connect.model.ContactInitiationMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.ContactInitiationMethod.INBOUND =>
      val r = INBOUND
      r
    case software.amazon.awssdk.services.connect.model.ContactInitiationMethod.OUTBOUND =>
      val r = OUTBOUND
      r
    case software.amazon.awssdk.services.connect.model.ContactInitiationMethod.TRANSFER =>
      val r = TRANSFER
      r
    case software.amazon.awssdk.services.connect.model.ContactInitiationMethod.QUEUE_TRANSFER =>
      val r = QUEUE_TRANSFER
      r
    case software.amazon.awssdk.services.connect.model.ContactInitiationMethod.CALLBACK =>
      val r = CALLBACK
      r
    case software.amazon.awssdk.services.connect.model.ContactInitiationMethod.API =>
      val r = API
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.ContactInitiationMethod {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactInitiationMethod =
      software.amazon.awssdk.services.connect.model.ContactInitiationMethod.UNKNOWN_TO_SDK_VERSION
  }
  case object INBOUND extends zio.aws.connect.model.ContactInitiationMethod {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactInitiationMethod =
      software.amazon.awssdk.services.connect.model.ContactInitiationMethod.INBOUND
  }
  case object OUTBOUND extends zio.aws.connect.model.ContactInitiationMethod {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactInitiationMethod =
      software.amazon.awssdk.services.connect.model.ContactInitiationMethod.OUTBOUND
  }
  case object TRANSFER extends zio.aws.connect.model.ContactInitiationMethod {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactInitiationMethod =
      software.amazon.awssdk.services.connect.model.ContactInitiationMethod.TRANSFER
  }
  case object QUEUE_TRANSFER
      extends zio.aws.connect.model.ContactInitiationMethod {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactInitiationMethod =
      software.amazon.awssdk.services.connect.model.ContactInitiationMethod.QUEUE_TRANSFER
  }
  case object CALLBACK extends zio.aws.connect.model.ContactInitiationMethod {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactInitiationMethod =
      software.amazon.awssdk.services.connect.model.ContactInitiationMethod.CALLBACK
  }
  case object API extends zio.aws.connect.model.ContactInitiationMethod {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactInitiationMethod =
      software.amazon.awssdk.services.connect.model.ContactInitiationMethod.API
  }
}
