package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{AgentStatusId, ARN}
import scala.jdk.CollectionConverters._
final case class CreateAgentStatusResponse(
    agentStatusARN: Option[ARN] = None,
    agentStatusId: Option[AgentStatusId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateAgentStatusResponse = {
    import CreateAgentStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateAgentStatusResponse
      .builder()
      .optionallyWith(
        agentStatusARN.map(value => ARN.unwrap(value): java.lang.String)
      )(_.agentStatusARN)
      .optionallyWith(
        agentStatusId.map(value =>
          AgentStatusId.unwrap(value): java.lang.String
        )
      )(_.agentStatusId)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateAgentStatusResponse.ReadOnly =
    zio.aws.connect.model.CreateAgentStatusResponse.wrap(buildAwsValue())
}
object CreateAgentStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateAgentStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateAgentStatusResponse =
      zio.aws.connect.model.CreateAgentStatusResponse(
        agentStatusARN.map(value => value),
        agentStatusId.map(value => value)
      )
    def agentStatusARN: Option[ARN]
    def agentStatusId: Option[AgentStatusId]
    def getAgentStatusARN: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("agentStatusARN", agentStatusARN)
    def getAgentStatusId: ZIO[Any, AwsError, AgentStatusId] =
      AwsError.unwrapOptionField("agentStatusId", agentStatusId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateAgentStatusResponse
  ) extends zio.aws.connect.model.CreateAgentStatusResponse.ReadOnly {
    override val agentStatusARN: Option[ARN] = scala
      .Option(impl.agentStatusARN())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val agentStatusId: Option[AgentStatusId] = scala
      .Option(impl.agentStatusId())
      .map(value => zio.aws.connect.model.primitives.AgentStatusId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateAgentStatusResponse
  ): zio.aws.connect.model.CreateAgentStatusResponse.ReadOnly = new Wrapper(
    impl
  )
}
