package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  ContactFlowDescription,
  InstanceId,
  TagValue,
  ContactFlowName,
  ContactFlowContent,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateContactFlowRequest(
    instanceId: InstanceId,
    name: ContactFlowName,
    `type`: zio.aws.connect.model.ContactFlowType,
    description: Option[ContactFlowDescription] = None,
    content: ContactFlowContent,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateContactFlowRequest = {
    import CreateContactFlowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateContactFlowRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .name(ContactFlowName.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(
        description.map(value =>
          ContactFlowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .content(ContactFlowContent.unwrap(content): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateContactFlowRequest.ReadOnly =
    zio.aws.connect.model.CreateContactFlowRequest.wrap(buildAwsValue())
}
object CreateContactFlowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateContactFlowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateContactFlowRequest =
      zio.aws.connect.model.CreateContactFlowRequest(
        instanceId,
        name,
        `type`,
        description.map(value => value),
        content,
        tags.map(value => value)
      )
    def instanceId: InstanceId
    def name: ContactFlowName
    def `type`: zio.aws.connect.model.ContactFlowType
    def description: Option[ContactFlowDescription]
    def content: ContactFlowContent
    def tags: Option[Map[TagKey, TagValue]]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getName: ZIO[Any, Nothing, ContactFlowName] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, zio.aws.connect.model.ContactFlowType] =
      ZIO.succeed(`type`)
    def getDescription: ZIO[Any, AwsError, ContactFlowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getContent: ZIO[Any, Nothing, ContactFlowContent] = ZIO.succeed(content)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateContactFlowRequest
  ) extends zio.aws.connect.model.CreateContactFlowRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val name: ContactFlowName =
      zio.aws.connect.model.primitives.ContactFlowName(impl.name())
    override val `type`: zio.aws.connect.model.ContactFlowType =
      zio.aws.connect.model.ContactFlowType.wrap(impl.`type`())
    override val description: Option[ContactFlowDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.connect.model.primitives.ContactFlowDescription(value)
      )
    override val content: ContactFlowContent =
      zio.aws.connect.model.primitives.ContactFlowContent(impl.content())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateContactFlowRequest
  ): zio.aws.connect.model.CreateContactFlowRequest.ReadOnly = new Wrapper(impl)
}
