package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{ARN, ContactFlowId}
import scala.jdk.CollectionConverters._
final case class CreateContactFlowResponse(
    contactFlowId: Option[ContactFlowId] = None,
    contactFlowArn: Option[ARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateContactFlowResponse = {
    import CreateContactFlowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateContactFlowResponse
      .builder()
      .optionallyWith(
        contactFlowId.map(value =>
          ContactFlowId.unwrap(value): java.lang.String
        )
      )(_.contactFlowId)
      .optionallyWith(
        contactFlowArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.contactFlowArn)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateContactFlowResponse.ReadOnly =
    zio.aws.connect.model.CreateContactFlowResponse.wrap(buildAwsValue())
}
object CreateContactFlowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateContactFlowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateContactFlowResponse =
      zio.aws.connect.model.CreateContactFlowResponse(
        contactFlowId.map(value => value),
        contactFlowArn.map(value => value)
      )
    def contactFlowId: Option[ContactFlowId]
    def contactFlowArn: Option[ARN]
    def getContactFlowId: ZIO[Any, AwsError, ContactFlowId] =
      AwsError.unwrapOptionField("contactFlowId", contactFlowId)
    def getContactFlowArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("contactFlowArn", contactFlowArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateContactFlowResponse
  ) extends zio.aws.connect.model.CreateContactFlowResponse.ReadOnly {
    override val contactFlowId: Option[ContactFlowId] = scala
      .Option(impl.contactFlowId())
      .map(value => zio.aws.connect.model.primitives.ContactFlowId(value))
    override val contactFlowArn: Option[ARN] = scala
      .Option(impl.contactFlowArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateContactFlowResponse
  ): zio.aws.connect.model.CreateContactFlowResponse.ReadOnly = new Wrapper(
    impl
  )
}
