package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  HoursOfOperationDescription,
  InstanceId,
  TagValue,
  TimeZone,
  CommonNameLength127,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateHoursOfOperationRequest(
    instanceId: InstanceId,
    name: CommonNameLength127,
    description: Option[HoursOfOperationDescription] = None,
    timeZone: TimeZone,
    config: Iterable[zio.aws.connect.model.HoursOfOperationConfig],
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateHoursOfOperationRequest = {
    import CreateHoursOfOperationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateHoursOfOperationRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .name(CommonNameLength127.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          HoursOfOperationDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .timeZone(TimeZone.unwrap(timeZone): java.lang.String)
      .config(config.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateHoursOfOperationRequest.ReadOnly =
    zio.aws.connect.model.CreateHoursOfOperationRequest.wrap(buildAwsValue())
}
object CreateHoursOfOperationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateHoursOfOperationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateHoursOfOperationRequest =
      zio.aws.connect.model.CreateHoursOfOperationRequest(
        instanceId,
        name,
        description.map(value => value),
        timeZone,
        config.map { item =>
          item.asEditable
        },
        tags.map(value => value)
      )
    def instanceId: InstanceId
    def name: CommonNameLength127
    def description: Option[HoursOfOperationDescription]
    def timeZone: TimeZone
    def config: List[zio.aws.connect.model.HoursOfOperationConfig.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getName: ZIO[Any, Nothing, CommonNameLength127] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, HoursOfOperationDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTimeZone: ZIO[Any, Nothing, TimeZone] = ZIO.succeed(timeZone)
    def getConfig: ZIO[Any, Nothing, List[
      zio.aws.connect.model.HoursOfOperationConfig.ReadOnly
    ]] = ZIO.succeed(config)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateHoursOfOperationRequest
  ) extends zio.aws.connect.model.CreateHoursOfOperationRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val name: CommonNameLength127 =
      zio.aws.connect.model.primitives.CommonNameLength127(impl.name())
    override val description: Option[HoursOfOperationDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.connect.model.primitives.HoursOfOperationDescription(value)
      )
    override val timeZone: TimeZone =
      zio.aws.connect.model.primitives.TimeZone(impl.timeZone())
    override val config
        : List[zio.aws.connect.model.HoursOfOperationConfig.ReadOnly] = impl
      .config()
      .asScala
      .map { item =>
        zio.aws.connect.model.HoursOfOperationConfig.wrap(item)
      }
      .toList
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateHoursOfOperationRequest
  ): zio.aws.connect.model.CreateHoursOfOperationRequest.ReadOnly = new Wrapper(
    impl
  )
}
