package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{ARN, HoursOfOperationId}
import scala.jdk.CollectionConverters._
final case class CreateHoursOfOperationResponse(
    hoursOfOperationId: Option[HoursOfOperationId] = None,
    hoursOfOperationArn: Option[ARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateHoursOfOperationResponse = {
    import CreateHoursOfOperationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateHoursOfOperationResponse
      .builder()
      .optionallyWith(
        hoursOfOperationId.map(value =>
          HoursOfOperationId.unwrap(value): java.lang.String
        )
      )(_.hoursOfOperationId)
      .optionallyWith(
        hoursOfOperationArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.hoursOfOperationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.CreateHoursOfOperationResponse.ReadOnly =
    zio.aws.connect.model.CreateHoursOfOperationResponse.wrap(buildAwsValue())
}
object CreateHoursOfOperationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateHoursOfOperationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateHoursOfOperationResponse =
      zio.aws.connect.model.CreateHoursOfOperationResponse(
        hoursOfOperationId.map(value => value),
        hoursOfOperationArn.map(value => value)
      )
    def hoursOfOperationId: Option[HoursOfOperationId]
    def hoursOfOperationArn: Option[ARN]
    def getHoursOfOperationId: ZIO[Any, AwsError, HoursOfOperationId] =
      AwsError.unwrapOptionField("hoursOfOperationId", hoursOfOperationId)
    def getHoursOfOperationArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("hoursOfOperationArn", hoursOfOperationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateHoursOfOperationResponse
  ) extends zio.aws.connect.model.CreateHoursOfOperationResponse.ReadOnly {
    override val hoursOfOperationId: Option[HoursOfOperationId] = scala
      .Option(impl.hoursOfOperationId())
      .map(value => zio.aws.connect.model.primitives.HoursOfOperationId(value))
    override val hoursOfOperationArn: Option[ARN] = scala
      .Option(impl.hoursOfOperationArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateHoursOfOperationResponse
  ): zio.aws.connect.model.CreateHoursOfOperationResponse.ReadOnly =
    new Wrapper(impl)
}
