package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{ARN, InstanceId}
import scala.jdk.CollectionConverters._
final case class CreateInstanceResponse(
    id: Option[InstanceId] = None,
    arn: Option[ARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateInstanceResponse = {
    import CreateInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateInstanceResponse
      .builder()
      .optionallyWith(
        id.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateInstanceResponse.ReadOnly =
    zio.aws.connect.model.CreateInstanceResponse.wrap(buildAwsValue())
}
object CreateInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateInstanceResponse =
      zio.aws.connect.model
        .CreateInstanceResponse(id.map(value => value), arn.map(value => value))
    def id: Option[InstanceId]
    def arn: Option[ARN]
    def getId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateInstanceResponse
  ) extends zio.aws.connect.model.CreateInstanceResponse.ReadOnly {
    override val id: Option[InstanceId] = scala
      .Option(impl.id())
      .map(value => zio.aws.connect.model.primitives.InstanceId(value))
    override val arn: Option[ARN] = scala
      .Option(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateInstanceResponse
  ): zio.aws.connect.model.CreateInstanceResponse.ReadOnly = new Wrapper(impl)
}
