package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{QueueId, ARN}
import scala.jdk.CollectionConverters._
final case class CreateQueueResponse(
    queueArn: Option[ARN] = None,
    queueId: Option[QueueId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateQueueResponse = {
    import CreateQueueResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateQueueResponse
      .builder()
      .optionallyWith(
        queueArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.queueArn)
      .optionallyWith(
        queueId.map(value => QueueId.unwrap(value): java.lang.String)
      )(_.queueId)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateQueueResponse.ReadOnly =
    zio.aws.connect.model.CreateQueueResponse.wrap(buildAwsValue())
}
object CreateQueueResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateQueueResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateQueueResponse =
      zio.aws.connect.model.CreateQueueResponse(
        queueArn.map(value => value),
        queueId.map(value => value)
      )
    def queueArn: Option[ARN]
    def queueId: Option[QueueId]
    def getQueueArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("queueArn", queueArn)
    def getQueueId: ZIO[Any, AwsError, QueueId] =
      AwsError.unwrapOptionField("queueId", queueId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateQueueResponse
  ) extends zio.aws.connect.model.CreateQueueResponse.ReadOnly {
    override val queueArn: Option[ARN] = scala
      .Option(impl.queueArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val queueId: Option[QueueId] = scala
      .Option(impl.queueId())
      .map(value => zio.aws.connect.model.primitives.QueueId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateQueueResponse
  ): zio.aws.connect.model.CreateQueueResponse.ReadOnly = new Wrapper(impl)
}
