package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  InstanceId,
  TagValue,
  QuickConnectName,
  QuickConnectDescription,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateQuickConnectRequest(
    instanceId: InstanceId,
    name: QuickConnectName,
    description: Option[QuickConnectDescription] = None,
    quickConnectConfig: zio.aws.connect.model.QuickConnectConfig,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateQuickConnectRequest = {
    import CreateQuickConnectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateQuickConnectRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .name(QuickConnectName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          QuickConnectDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .quickConnectConfig(quickConnectConfig.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateQuickConnectRequest.ReadOnly =
    zio.aws.connect.model.CreateQuickConnectRequest.wrap(buildAwsValue())
}
object CreateQuickConnectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateQuickConnectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateQuickConnectRequest =
      zio.aws.connect.model.CreateQuickConnectRequest(
        instanceId,
        name,
        description.map(value => value),
        quickConnectConfig.asEditable,
        tags.map(value => value)
      )
    def instanceId: InstanceId
    def name: QuickConnectName
    def description: Option[QuickConnectDescription]
    def quickConnectConfig: zio.aws.connect.model.QuickConnectConfig.ReadOnly
    def tags: Option[Map[TagKey, TagValue]]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getName: ZIO[Any, Nothing, QuickConnectName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, QuickConnectDescription] =
      AwsError.unwrapOptionField("description", description)
    def getQuickConnectConfig
        : ZIO[Any, Nothing, zio.aws.connect.model.QuickConnectConfig.ReadOnly] =
      ZIO.succeed(quickConnectConfig)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateQuickConnectRequest
  ) extends zio.aws.connect.model.CreateQuickConnectRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val name: QuickConnectName =
      zio.aws.connect.model.primitives.QuickConnectName(impl.name())
    override val description: Option[QuickConnectDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.connect.model.primitives.QuickConnectDescription(value)
      )
    override val quickConnectConfig
        : zio.aws.connect.model.QuickConnectConfig.ReadOnly =
      zio.aws.connect.model.QuickConnectConfig.wrap(impl.quickConnectConfig())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateQuickConnectRequest
  ): zio.aws.connect.model.CreateQuickConnectRequest.ReadOnly = new Wrapper(
    impl
  )
}
