package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{QuickConnectId, ARN}
import scala.jdk.CollectionConverters._
final case class CreateQuickConnectResponse(
    quickConnectARN: Option[ARN] = None,
    quickConnectId: Option[QuickConnectId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateQuickConnectResponse = {
    import CreateQuickConnectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateQuickConnectResponse
      .builder()
      .optionallyWith(
        quickConnectARN.map(value => ARN.unwrap(value): java.lang.String)
      )(_.quickConnectARN)
      .optionallyWith(
        quickConnectId.map(value =>
          QuickConnectId.unwrap(value): java.lang.String
        )
      )(_.quickConnectId)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateQuickConnectResponse.ReadOnly =
    zio.aws.connect.model.CreateQuickConnectResponse.wrap(buildAwsValue())
}
object CreateQuickConnectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateQuickConnectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateQuickConnectResponse =
      zio.aws.connect.model.CreateQuickConnectResponse(
        quickConnectARN.map(value => value),
        quickConnectId.map(value => value)
      )
    def quickConnectARN: Option[ARN]
    def quickConnectId: Option[QuickConnectId]
    def getQuickConnectARN: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("quickConnectARN", quickConnectARN)
    def getQuickConnectId: ZIO[Any, AwsError, QuickConnectId] =
      AwsError.unwrapOptionField("quickConnectId", quickConnectId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateQuickConnectResponse
  ) extends zio.aws.connect.model.CreateQuickConnectResponse.ReadOnly {
    override val quickConnectARN: Option[ARN] = scala
      .Option(impl.quickConnectARN())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val quickConnectId: Option[QuickConnectId] = scala
      .Option(impl.quickConnectId())
      .map(value => zio.aws.connect.model.primitives.QuickConnectId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateQuickConnectResponse
  ): zio.aws.connect.model.CreateQuickConnectResponse.ReadOnly = new Wrapper(
    impl
  )
}
